module net.BurtonRadons.spyl.expressionSymbol;

private import net.BurtonRadons.spyl.expression;
private import net.BurtonRadons.spyl.value;
private import net.BurtonRadons.spyl.mark;
private import net.BurtonRadons.spyl.scope;

/** A symbol reference. */
class SymbolExpression : Expression
{
    char [] name; /**< Name of the symbol. */
    
    /** Assign the parameters. */
    this (Mark mark, char [] name)
    {
        super (mark);
        this.name = name.dup;
    }
    
    override Value evaluate (Scope scope)
    {
        return scope.retrieve (name);
    }
    
    override char [] toString ()
    {
        return name;
    }
    
    override int precedence ()
    {
        return 16;
    }
}
